/*
 * TagEntry.cpp
 *
 *  Created on: 14.10.2009
 *      Author: stefan.detter
 */

#include "TagData.h"

TagData::TagData()
{

}

TagData::TagData(QString tagId, QString visualTagId, QString tagType)
{
	m_tagId = tagId;
    m_visualTagId = visualTagId;
	m_tagType = tagType;
}

TagData::TagData(const TagData & other)
{
	this->m_tagId = other.m_tagId;
	this->m_tagType = other.m_tagType;
    this->m_visualTagId = other.m_visualTagId;
    this->m_properties = other.m_properties;
}

TagData::~TagData()
{
}


TagData& TagData::operator= (const TagData& other)
{
	this->m_tagId = other.m_tagId;
    this->m_tagType = other.m_tagType;
    this->m_visualTagId = other.m_visualTagId;
    this->m_properties = other.m_properties;
	return *this;
}

bool TagData::operator == (const TagData& other) const
{
	return (this->m_tagId == other.m_tagId) && (this->m_tagType == other.m_tagType);
}

void TagData::addValue(QString key, QVariant value)
{
	m_properties.insert(key, value);
}


QString TagData::tagId() const
{
    return m_tagId;
}

QString TagData::visualTagId() const
{
    return m_visualTagId;
}

QString TagData::tagType() const
{
	return m_tagType;
}

bool TagData::hasValue(QString key) const
{
	return m_properties.contains(key);
}

QVariant TagData::value(QString key) const
{
	return m_properties.value(key);
}


